<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RfBuildings extends Model 
{

    protected $table = 'rf_buildings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'rf_community_id', 'no_floors', 'year_build', 'map', 'is_active', 'created_by', 'updated_by');

    public function community()
    {
        return $this->belongsTo('RFTenant\Models\RfCommunity');
    }

    public function units()
    {
        return $this->hasMany('RFTenant\Models\RfUnits');
    }

}